import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {FormField} from 'react-form'
import {FormFeedback, FormText} from "reactstrap";
import classNames from 'classnames';

class TextWrapper extends Component {

    constructor(props) {
        super(props);
    }

    render() {

        const {
            fieldApi,
            onInput,
            helpText,
            className,
            ...rest
        } = this.props;

        const {
            getValue,
            getError,
            getTouched,
            // getWarning,
            // getSuccess,
            setValue,
            setTouched,
        } = fieldApi;

        const touched = getTouched();
        const error = getError();
        // const warning = getWarning();
        // const success = getSuccess();

        return (
            <div>
                <input
                    className={classNames(className, {'is-invalid': error && touched})}
                    value={getValue() || ''}
                    onChange={( e ) => {
                        setValue(e.target.value);
                        if ( onInput ) {
                            onInput( e );
                        }
                    }}
                    onBlur={() => {
                        setTouched();
                    }}
                    {...rest} />
                { error ? <div className="invalid-feedback">{error}</div> : null }
                { helpText ? <FormText>{helpText}</FormText> : null}
            </div>
        );
    }
}

const Text = FormField(TextWrapper);

Text.defaultProps = {};

Text.propTypes = {
    helpText: PropTypes.string,
    field: PropTypes.string.isRequired,
};

export default Text;